/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1887;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

@Deprecated
public class LootModifier
extends Modifier
implements LootingModifierHook,
HarvestEnchantmentsModifierHook {
    @Nullable
    private final class_1887 enchantment;
    private final int enchantmentLevel;
    private final int lootingLevel;
    private final ModifierLevelDisplay levelDisplay;
    public static final GenericLoaderRegistry.IGenericLoader<LootModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<LootModifier>(){

        @Override
        public LootModifier deserialize(JsonObject json) {
            class_1887 enchantment = null;
            int enchantmentLevel = 0;
            if (json.has("enchantment")) {
                JsonObject enchantmentJson = class_3518.method_15296((JsonObject)json, (String)"enchantment");
                enchantment = (class_1887)JsonHelper.getAsEntry(class_7923.field_41176, enchantmentJson, "name");
                enchantmentLevel = class_3518.method_15282((JsonObject)enchantmentJson, (String)"level", (int)1);
            }
            int looting = class_3518.method_15282((JsonObject)json, (String)"looting", (int)0);
            ModifierLevelDisplay display = ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            return new LootModifier(enchantment, enchantmentLevel, looting, display);
        }

        @Override
        public void serialize(LootModifier object, JsonObject json) {
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize(object.levelDisplay));
            if (object.enchantmentLevel > 0 && object.enchantment != null) {
                JsonObject enchantment = new JsonObject();
                enchantment.addProperty("name", Objects.requireNonNull(class_7923.field_41176.method_10221((Object)object.enchantment)).toString());
                enchantment.addProperty("level", (Number)object.enchantmentLevel);
                json.add("enchantment", (JsonElement)enchantment);
            }
            if (object.lootingLevel > 0) {
                json.addProperty("looting", (Number)object.lootingLevel);
            }
        }

        @Override
        public LootModifier fromNetwork(class_2540 buffer) {
            int enchantmentLevel = buffer.method_10816();
            class_1887 enchantment = null;
            if (enchantmentLevel > 0) {
                enchantment = (class_1887)class_7923.field_41176.method_10223(buffer.method_10810());
            }
            int lootingLevel = buffer.method_10816();
            ModifierLevelDisplay display = ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            return new LootModifier(enchantment, enchantmentLevel, lootingLevel, display);
        }

        @Override
        public void toNetwork(LootModifier object, class_2540 buffer) {
            if (object.enchantmentLevel > 0 && object.enchantment != null) {
                buffer.method_10804(object.enchantmentLevel);
                buffer.method_10812(class_7923.field_41176.method_10221((Object)object.enchantment));
            } else {
                buffer.method_10804(0);
            }
            buffer.method_10804(object.lootingLevel);
            ModifierLevelDisplay.LOADER.toNetwork(object.levelDisplay, buffer);
        }
    };

    public LootModifier(class_1887 enchantment, int level, ModifierLevelDisplay levelDisplay) {
        this(enchantment, level, 0, levelDisplay);
    }

    public LootModifier(int lootingLevel, ModifierLevelDisplay levelDisplay) {
        this(null, 0, lootingLevel, levelDisplay);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOL_LOOTING, TinkerHooks.LEGGINGS_LOOTING, TinkerHooks.PROJECTILE_LOOTING, TinkerHooks.TOOL_HARVEST_ENCHANTMENTS, TinkerHooks.LEGGINGS_HARVEST_ENCHANTMENTS);
    }

    @Override
    public class_2561 getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public int getLootingValue(IToolStackView tool, ModifierEntry modifier, class_1309 holder, class_1297 target, @Nullable class_1282 damageSource, int looting) {
        return looting + this.lootingLevel * modifier.getLevel();
    }

    @Override
    public void applyHarvestEnchantments(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, BiConsumer<class_1887, Integer> consumer) {
        if (this.enchantment != null && this.enchantmentLevel > 0) {
            consumer.accept(this.enchantment, this.enchantmentLevel * modifier.getLevel());
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    public LootModifier(@Nullable class_1887 enchantment, int enchantmentLevel, int lootingLevel, ModifierLevelDisplay levelDisplay) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.lootingLevel = lootingLevel;
        this.levelDisplay = levelDisplay;
    }
}

